#include "CGen2ExplicitReadDialog.h"

#include <QMessageBox>

#include <tag/QrfeGen2Tag>


CGen2ExplicitReadDialog::CGen2ExplicitReadDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	setInfoEdit(ui.infoEdit);

	connect(ui.okButton, 			SIGNAL(clicked()), 					this, SLOT(accept()));
	connect(ui.cancelButton, 		SIGNAL(clicked()), 					this, SLOT(reject()));

	connect(ui.readButton, 			SIGNAL(clicked()), 					this, SLOT(read()));
	connect(ui.writeButton, 		SIGNAL(clicked()), 					this, SLOT(write()));

	connect(ui.memBankBox, 			SIGNAL(currentIndexChanged(int)), 	this, SLOT(paramsChanged()));
	connect(ui.wordAddressBox, 		SIGNAL(valueChanged(int)), 			this, SLOT(paramsChanged()));
	connect(ui.wordCountBox, 		SIGNAL(valueChanged(int)), 			this, SLOT(paramsChanged()));

}

CGen2ExplicitReadDialog::~CGen2ExplicitReadDialog()
{

}

int CGen2ExplicitReadDialog::exec(QrfeGen2Tag* tag)
{
	m_tag = tag;

	clearInfo();

	ui.tagIdEdit->setText(m_tag->tagId());

	ui.memBankBox->setCurrentIndex(0);
	ui.wordAddressBox->setValue(0);
	ui.wordCountBox->setValue(1);
	ui.accessPasswordEdit->setText("00-00-00-00");
	ui.dataLineEdit->clear();

	return QDialog::exec();
}


void CGen2ExplicitReadDialog::read()
{
	clearInfo();

	if(!ui.accessPasswordEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	bool ok = false;
	QByteArray passw = QrfeGlobal::stringToBytes(ui.accessPasswordEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	uchar 	membank = ui.memBankBox->currentIndex();
	ushort 	address = ui.wordAddressBox->value();
	uchar 	count   = ui.wordCountBox->value() * 2;

	QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

	QByteArray data;

	res = m_tag->readFromTag((QrfeGen2Tag::MEMORY_BANK)membank, address, passw, count, data);

	QString inputMask;
	QString text;
	if(res == QrfeGlobal::TMI_OK)
	{
		infoSetOK("-- Read data from tag - OK -- ");
		infoAppend("Read the data: " + QrfeGlobal::bytesToString(data));

		for(int i = 0; i < data.size(); i++)
			inputMask += "HH-";
		inputMask.remove(inputMask.size()-1, 1);

		text = QrfeGlobal::bytesToString(data);

		ui.writeButton->setEnabled(true);
	}
	else
	{
		inputMask = "";
		text = "";
		handleError(res, "Could not read data from the tag");
	}

	ui.dataLineEdit->setInputMask(inputMask);
	ui.dataLineEdit->setText(text);
}

void CGen2ExplicitReadDialog::write()
{
	bool ok;

	clearInfo();

	if(!ui.accessPasswordEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	ok = false;
	QByteArray passw = QrfeGlobal::stringToBytes(ui.accessPasswordEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	if(!ui.dataLineEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The data is not valid!");
		return;
	}

	ok = false;
	QByteArray data = QrfeGlobal::stringToBytes(ui.dataLineEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The data is not valid!");
		return;
	}

	uchar 	membank = ui.memBankBox->currentIndex();
	ushort 	address = ui.wordAddressBox->value();

	QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

	res = m_tag->writeToTag((QrfeGen2Tag::MEMORY_BANK)membank, address, passw, data);

	if(res == QrfeGlobal::TMI_OK)
	{
		infoSetOK("-- Wrote data from tag - OK -- ");
		infoAppend("Wrote the data: " + QrfeGlobal::bytesToString(data));
	}
	else
	{
		handleError(res, "Could not write data from the tag");
	}
}

void CGen2ExplicitReadDialog::paramsChanged()
{
	ui.writeButton->setEnabled(false);
}

